/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import teamdraco.unnamedanimalmod.UAMHelper;
import teamdraco.unnamedanimalmod.common.block.MangroveSaplingBlock;
import teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove.Entry;
import teamdraco.unnamedanimalmod.init.UAMBlocks;

public class MangroveTreeHelper {
    public static int minimumLandTrunkHeight = 7;
    public static int landTrunkHeightExtra = 2;
    public static int minimumSideLandTrunkHeight = 1;
    public static int sideLandTrunkHeightExtra = 2;
    public static int minimumWaterTrunkOffset = 2;
    public static int waterTrunkOffsetExtra = 1;
    public static int minimumWaterTrunkHeight = 7;
    public static int waterTrunkHeightExtra = 2;
    public static int maximumUpwardsWaterRootOffset = 2;
    public static int minimumWaterRootCoreOffset = 2;
    public static int waterRootCoreOffsetExtra = 1;
    public static int maximumDownwardsBranchOffset = 2;
    public static int minimumBranchCoreOffset = 3;
    public static int branchCoreOffsetExtra = 1;
    public static int minimumBranchHeight = 2;
    public static int branchHeightExtra = 2;
    public static int leavesHeight = 4;
    public static int leavesHeightExtra = 1;
    public static int leavesStartDownwardsOffsetExtra = 2;
    public static int leavesSize = 2;
    public static int leavesSizeExtra = 1;
    public static int leavesShrinkStart = 2;
    public static int minimumVineHeight = 7;
    public static int vineHeightExtra = 2;

    public static void fill(ISeedReader reader, ArrayList<Entry> filler) {
        for (Entry entry : filler) {
            reader.func_180501_a(entry.pos, entry.state, 3);
        }
    }

    public static void fillLeaves(ISeedReader reader, Random rand, ArrayList<Entry> filler) {
        Collection<Entry> vineFiller = UAMHelper.takeAll(filler, p -> p.state.func_177230_c() instanceof VineBlock);
        for (Entry entry : filler) {
            if (!MangroveTreeHelper.canPlace(reader, entry.pos)) continue;
            reader.func_180501_a(entry.pos, entry.state, 3);
        }
        for (Entry entry : vineFiller) {
            BlockPos vinePos;
            if (!MangroveTreeHelper.canPlace(reader, entry.pos)) continue;
            int vinesLength = minimumVineHeight + rand.nextInt(vineHeightExtra + 1);
            for (int i = 0; i < vinesLength && MangroveTreeHelper.canPlace(reader, vinePos = entry.pos.func_177979_c(i)) && !reader.func_201671_F(vinePos); ++i) {
                reader.func_180501_a(vinePos, entry.state, 3);
            }
        }
    }

    public static void makeLeafBlob(ArrayList<Entry> filler, Random rand, BlockPos pos, int branchHeight) {
        int randomOffset = rand.nextInt(leavesStartDownwardsOffsetExtra + 1);
        int startingLeavesOffset = branchHeight - randomOffset;
        int finalLeavesHeight = leavesHeight + rand.nextInt(leavesHeightExtra + 1);
        int size = leavesSize - 1 + rand.nextInt(leavesSizeExtra);
        for (int i = 0; i < finalLeavesHeight; ++i) {
            int y = startingLeavesOffset + i;
            BlockPos blobSliceCenter = pos.func_177981_b(y);
            size = i < leavesShrinkStart ? ++size : --size;
            MangroveTreeHelper.makeLeafSlice(filler, rand, blobSliceCenter, size, i < leavesShrinkStart);
        }
    }

    public static void makeLeafSlice(ArrayList<Entry> filler, Random rand, BlockPos pos, int leavesSize, boolean vines) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                BlockPos leavesPos = new BlockPos((Vector3i)pos).func_177982_a(x, 0, z);
                if (rand.nextFloat() > 0.15f) {
                    filler.add(new Entry(leavesPos, (BlockState)((Block)UAMBlocks.MANGROVE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1))));
                } else {
                    filler.add(new Entry(leavesPos, (BlockState)((Block)UAMBlocks.FLOWERING_MANGROVE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1))));
                }
                if (!vines) continue;
                if ((Math.abs(x) == leavesSize || Math.abs(z) == leavesSize) && rand.nextFloat() < 0.2f) {
                    Direction[] directions;
                    for (Direction direction : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
                        filler.add(new Entry(leavesPos.func_177972_a(direction), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_196546_A.get(direction.func_176734_d()), (Comparable)Boolean.valueOf(true))));
                    }
                }
                if (!(rand.nextFloat() < 0.1f)) continue;
                filler.add(new Entry(leavesPos.func_177977_b(), ((Block)UAMBlocks.MANGROVE_FRUIT.get()).func_176223_P()));
            }
        }
    }

    public static boolean canPlace(ISeedReader reader, BlockPos pos) {
        if (!World.func_175701_a((BlockPos)pos)) {
            return false;
        }
        return reader.func_180495_p(pos).func_177230_c() instanceof MangroveSaplingBlock || reader.func_201671_F(pos) || reader.func_175623_d(pos) || reader.func_180495_p(pos).func_185904_a().func_76222_j();
    }
}

